window.onload = function() {
	setView(getStatus());

	try
	{	
		qqbrowser.bookmark.getSyncState(function(syncStateId) {
			setSyncStatus(syncStateId);	
		});
		
		qqbrowser.bookmark.onSyncStateChanged.addListener(function(syncStateId) {
			setSyncStatus(syncStateId);		
		});	
	}
	catch (e) {}
	
	// 关闭窗口
	document.getElementById('notify-confirm').onclick = function() {
		qqbrowser.dialog.close(0); // 关闭页面
	}
	document.getElementById('notify-cancel').onclick = function() {
		qqbrowser.dialog.close(0); // 关闭页面
	}
	
	// 重试按钮
//	document.getElementById('notify-retry-disabled').onclick = function() {
//		qqbrowser.dialog.close(0); // 关闭页面
//	}
	document.getElementById('notify-retry').onclick = function() {
		qqbrowser.bookmark.retrySync();
	}	
};

function setSyncStatus(syncStateId) {
	// 根据id改变界面、title
/*		BSSI_OK = 0,
		BSSI_DOWNLOADING, 1
		BSSI_DOWNLOAD_ERROR, 2
		BSSI_UPLOADING , 3
		BSSI_UPLOAD_ERROR, 4 */
	// download status
	if(getStatus() == 'downloadTip' && syncStateId == 1) { // retry
		setView('downloadRetry');
	} else if(getStatus() == 'downloadTip' && syncStateId == 0) { // fail
		setView('downloadSuccess');
	} else if(getStatus() == 'downloadTip' && syncStateId == 2) { // fail
		setView('downloadFail');
	}
	// upload status
	else if(getStatus() == 'uploadFail' && syncStateId == 3) { // retry
		setView('uploadRetry');
	} else if(getStatus() == 'uploadFail' && syncStateId == 0) { // fail
		setView('uploadSuccess');
	} else if(getStatus() == 'uploadFail' && syncStateId == 4) { // fail
		setView('uploadFail');
	}
}

function setView(status) {
	hideButtons();
	console.info(status);
	// download error
	if(status == 'downloadTip') {
		setImg('fail');
		setTitle('无法对网络收藏做修改');
		setContent('网络故障，暂时无法更新，重试成功后可继续操作');
		showButton('notify-retry');
		showButton('notify-confirm');
	} else if(status == 'downloadRetry') {
		setImg('retry');
		setTitle('正在重试');
		setContent('正在尝试下载最新的网络收藏...');
		showButton('notify-retry-disabled');
		showButton('notify-cancel');
 	} else if(status == 'downloadSuccess') {
		setImg('success');
		setTitle('网络收藏下载成功');
		setContent('您可以正常使用网络收藏！');
		showButton('notify-confirm');
 	} else if(status == 'downloadFail') {
		setImg('fail');
		setTitle('网络收藏下载失败');
		setContent('暂时无法对网络收藏做修改，您可以稍后重试');
		showButton('notify-confirm');
		showButton('notify-retry');
	} else if(status == 'downloadEdit') {
		setImg('fail');
		setTitle('无法修改');
		setContent('正在更新网络收藏，请稍后再做修改');
		showButton('notify-confirm');
	}
	// upload error 
	else if(status == 'uploadFail') {
		setImg('fail');
		setTitle('收藏上传失败');
		setContent('由于网络故障，您刚才的修改暂时无法上传');
		showButton('notify-confirm');
		showButton('notify-retry');
	} else if(status == 'uploadRetry') {
		setImg('retry');
		setTitle('正在重试');
		setContent('正在上传收藏到网络...');
		showButton('notify-cancel');
		showButton('notify-retry-disabled');
	} else if(status == 'uploadSuccess') {
		setImg('success');
		setTitle('收藏上传成功');
		setContent('您可以正常使用网络收藏');
		showButton('notify-confirm');
	} else { // default
		setImg('fail');
		setTitle('无法对网络收藏做修改');
		setContent('网络故障，暂时无法更新');
		showButton('notify-retry');
		showButton('notify-confirm');
	}
}

function setImg(style) {
	document.getElementById('notify-body').className = style;
}

function hideButtons() {
	document.getElementById('notify-confirm').style.display = 'none';
	document.getElementById('notify-cancel').style.display = 'none';
	document.getElementById('notify-retry-disabled').style.display = 'none';
	document.getElementById('notify-retry').style.display = 'none';
}

function showButton(buttonName) {
	document.getElementById(buttonName).style.display = 'block';
}

function setTitle(title) {
	try {
		qqbrowser.dialog.setTitle(0, title);
	} catch(e) {}
}

function setContent(content) {
	document.getElementById('notify-text').innerHTML = content;
}

function parseUrl() {
	var url = location.href;
	var item = [];
	var result = {};
	var query = url.substr(url.indexOf('?') + 1);
	var tmp = query.split('&');

	for(var i = 0; i < tmp.length; i++){
		item = tmp[i].split('=');
		result[item[0]] = item[1];
	}
	return result;
}

function getStatus() {
//	return $('#menu ul').attr('sourceId');
	try
	{
		var stat = parseUrl().status.split('#')[0];		
	}
	catch (e)
	{	
		var stat = 'downloadTip';
	}


	try{
		qqbrowser.log.info("err dlg stat: "+stat);
	}catch(err){
	}
	return stat;
}
